package ru.yandex.travel.orders.entities.partners;

import java.math.BigDecimal;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class DolphinBillingPartnerAgreement implements BillingPartnerAgreement {
    private Long billingClientId;

    private Long billingContractId;

    private BigDecimal confirmRate;

    @Deprecated
    private Map<Integer, BigDecimal> refundPenalties;

    // todo(tlg-13): temporary w/a for field rename transition period, should be removed with the unit test
    @Deprecated
    public void setRefundRates(Map<Integer, BigDecimal> refundPenalties) {
        this.refundPenalties = refundPenalties;
    }
}
