package ru.yandex.travel.orders.entities.promo;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import ru.yandex.travel.orders.commons.proto.EPromoCodeNominalType;

@Data
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY)
@JsonSubTypes({
        @JsonSubTypes.Type(value = SimplePromoCodeGenerationConfig.class)
})
public class BasePromoCodeGenerationConfig {
    private Double nominal;
    private EPromoCodeNominalType nominalType;
    private Integer maxUsagePerUser;
    private Integer maxActivations;
    private ValidTillGenerationType validTillGenerationType;
    private LocalDate fixedDate;
    private Long fixedDaysDuration;
}
