package ru.yandex.travel.orders.entities.promo;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Type;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.entities.FiscalItem;

/**
 * Discount for the fiscal item. Can be a discount by promo code, or as a special discount for some promo campaign
 * (as a discount for the given hotel, for example).
 */
@Data
@Entity
@Table(name = "fiscal_item_discounts")
@BatchSize(size = 100)
@EqualsAndHashCode(exclude = "fiscalItem")
@ToString(exclude = "fiscalItem")
public class FiscalItemDiscount {

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "fiscal_item_discounts_id_seq"
    )
    @SequenceGenerator(
            name = "fiscal_item_discounts_id_seq",
            sequenceName = "fiscal_item_discounts_id_seq",
            allocationSize = 1
    )
    private Long id;

    @ManyToOne
    private PromoCodeApplication promoCodeApplication;

    @ManyToOne
    private FiscalItem fiscalItem;

    @Type(type = "money-proto-enum")
    @Columns(columns = {
            @Column(name = "discount_amount"), @Column(name = "discount_currency")
    })
    private Money discount;

    public boolean isPromoCodeDiscount() {
        return promoCodeApplication != null;
    }
}
