package ru.yandex.travel.orders.entities.promo;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.BatchSize;

import ru.yandex.travel.orders.entities.Order;

@Entity
@Data
public class OrderGeneratedPromoCodes {
    @Id
    private UUID id;
    @OneToOne
    private Order order;
    @Setter(AccessLevel.NONE)
    @Getter(AccessLevel.NONE)
    @OneToMany(mappedBy = "orderGenerated")
    @BatchSize(size = 100)
    private List<PromoCode> promoCodes;

    public static OrderGeneratedPromoCodes createForOrder(Order order) {
        OrderGeneratedPromoCodes result = new OrderGeneratedPromoCodes();
        result.setId(UUID.randomUUID());
        result.setOrder(order);
        order.setGeneratedPromoCodes(result);
        return result;
    }

    public void addPromoCode(PromoCode promoCode) {
        if (promoCodes == null) {
            promoCodes = new ArrayList<>();
        }
        promoCode.setOrderGenerated(this);
        promoCodes.add(promoCode);
    }

    public List<PromoCode> getPromoCodes() {
        if (promoCodes == null) {
            return List.of();
        } else {
            return promoCodes;
        }
    }
}
