package ru.yandex.travel.orders.entities.promo;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "promo_actions")
@Data
public class PromoAction {

    @Id
    private UUID id;

    private String name;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Type(type = "jsonb-object")
    private DiscountApplicationConfig discountApplicationConfig;

    @Type(type = "custom-enum")
    private PromoCodeGenerationType promoCodeGenerationType;

    @Type(type = "jsonb-object")
    private BasePromoCodeGenerationConfig promoCodeGenerationConfig;

    private Instant validTill;

    private Instant validFrom;

    // Budget restrictions. Always in RUB
    private BigDecimal initialBudget;
    private BigDecimal remainingBudget;

    @Version
    private Long version;

    public void restoreBudgetSpending(PromoCodeApplication application) {
        if (getRemainingBudget() != null) {
            setRemainingBudget(
                    getRemainingBudget().add(
                            application.getDiscount().getNumberStripped()
                    )
            );
        }
    }

    public void subtractFromBudget(PromoCodeApplication application) {
        if (getRemainingBudget() != null) {
            setRemainingBudget(
                    getRemainingBudget().subtract(
                            application.getDiscount().getNumberStripped()
                    )
            );
        }
    }
}
