package ru.yandex.travel.orders.entities.promo;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

/**
 * Связывает промокод и пользователя. С заказом связано через {@link PromoCodeApplication}
 */
@Entity
@Table(name = "promo_code_activations")
@Data
@EqualsAndHashCode(exclude = {"applications"})
@ToString(exclude = {"applications"})
@BatchSize(size = 100)
public class PromoCodeActivation {

    @Id
    private UUID id;

    @ManyToOne
    private PromoCode promoCode;

    @OneToMany(mappedBy = "promoCodeActivation")
    private List<PromoCodeApplication> applications;

    private String passportId;

    @CreationTimestamp
    private Instant activatedAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private Integer timesUsed;

    @Version
    private Long version;

    public static PromoCodeActivation activate(String passportId, PromoCode promoCode) {
        promoCode.incrementAllowedActivationsCount();
        PromoCodeActivation activation = new PromoCodeActivation();
        activation.setId(UUID.randomUUID());
        activation.setPassportId(passportId);
        activation.setPromoCode(promoCode);
        return activation;
    }

    public Integer getTimesUsed() {
        return timesUsed != null ? timesUsed : 0;
    }

    public void incrementTimesUsed() {
        if (timesUsed == null) {
            timesUsed = 1;
        } else {
            timesUsed = timesUsed + 1;
        }
    }

    public void decrementTimesUsed() {
        if (timesUsed == null) {
            timesUsed = 0;
        } else {
            timesUsed = timesUsed - 1;
        }
    }
}
