package ru.yandex.travel.orders.entities.promo;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Getter
@RequiredArgsConstructor
public enum PromoCodeActivationsStrategy implements ValueBasedEnum<String> {
    UNLIMITED_ACTIVATIONS("unlimited_activations"),
    LIMITED_ACTIVATIONS("limited_activations");

    private final String value;

    public static final EnumIndex<String, PromoCodeActivationsStrategy> index =
            EnumIndex.create(PromoCodeActivationsStrategy.class);

    public static PromoCodeActivationsStrategy getByValue(String value) {
        return index.getByValue(value);
    }
}
