package ru.yandex.travel.orders.entities.promo;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum PromoCodeBehaviourOverride implements ValueBasedEnum<String> {
    RESTRICT_APPLICATION("restrict_application"),
    RESTRICT_ALREADY_APPLIED("restrict_already_applied");

    private final String value;

    public static final EnumIndex<String, PromoCodeBehaviourOverride> index =
            EnumIndex.create(PromoCodeBehaviourOverride.class);

    public static PromoCodeBehaviourOverride getByValue(String value) {
        return index.getByValue(value);
    }
}
