package ru.yandex.travel.orders.entities.promo;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.orders.services.promo.proto.EPromoCodeGenerationType;

@Getter
@RequiredArgsConstructor
public enum PromoCodeGenerationType implements ValueBasedEnum<String> {
    SIMPLE_GENERATION("simple_generation", EPromoCodeGenerationType.PGT_SIMPLE);

    @JsonValue
    private final String value;
    private final EPromoCodeGenerationType protoValue;

    public static final EnumIndex<String, PromoCodeGenerationType> BY_VALUE =
            EnumIndex.create(PromoCodeGenerationType.class);

    @JsonCreator
    public static PromoCodeGenerationType getByValue(String value) {
        return BY_VALUE.getByValue(value);
    }

    public static EPromoCodeGenerationType mapToProto(@Nullable PromoCodeGenerationType restriction) {
        if (restriction == null) {
            return EPromoCodeGenerationType.PGT_NONE;
        }
        return restriction.getProtoValue();
    }
}
