package ru.yandex.travel.orders.entities.promo;

import java.time.Instant;

import ru.yandex.travel.orders.entities.Order;

public class PromoCodeHelpers {
    public static Instant getPromoCodeValidFrom(PromoCode promoCode) {
        return promoCode.getValidFrom() != null ? promoCode.getValidFrom() : promoCode.getPromoAction().getValidFrom();
    }

    public static Instant getPromoCodeValidTill(PromoCode promoCode) {
        return promoCode.getValidTill() != null ? promoCode.getValidTill() : promoCode.getPromoAction().getValidTill();
    }

    public static void blacklistGeneratedPromoCodesForOrder(Order order) {
        if (order.getGeneratedPromoCodes() != null && order.getGeneratedPromoCodes().getPromoCodes().size() > 0) {
            order.getGeneratedPromoCodes().getPromoCodes().forEach( it -> it.setBlacklisted(true));
        }
    }
}
