package ru.yandex.travel.orders.entities.promo;

import javax.annotation.Nullable;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.orders.services.promo.proto.EUserTypeRestriction;

@RequiredArgsConstructor
@Getter
public enum UserTypeRestriction implements ValueBasedEnum<String> {
    STAFF_ONLY("staff_only", EUserTypeRestriction.UTR_STAFF_ONLY),
    PLUS_ONLY("plus_only", EUserTypeRestriction.UTR_PLUS_ONLY);

    private static final EnumIndex<String, UserTypeRestriction> BY_VALUE = EnumIndex.create(UserTypeRestriction.class);

    private final String value;
    private final EUserTypeRestriction protoValue;

    public static UserTypeRestriction fromString(String value) {
        return BY_VALUE.getByValue(value);
    }

    public static EUserTypeRestriction mapToProto(@Nullable UserTypeRestriction restriction) {
        if (restriction == null) {
            return EUserTypeRestriction.UTR_NONE;
        }
        return restriction.getProtoValue();
    }
}
