package ru.yandex.travel.orders.entities.promo;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.orders.services.promo.proto.EPromoCodeValidTillGenerationType;

@Getter
@RequiredArgsConstructor
public enum ValidTillGenerationType implements ValueBasedEnum<String> {
    FIXED_DATE("fixed_date", EPromoCodeValidTillGenerationType.PCVTGT_FIXED_DATE),
    FIXED_DURATION("fixed_duration", EPromoCodeValidTillGenerationType.PCVTGT_FIXED_DURATION);

    @JsonValue
    private final String value;
    private final EPromoCodeValidTillGenerationType protoValue;

    public static final EnumIndex<String, ValidTillGenerationType> BY_VALUE = EnumIndex.create(ValidTillGenerationType.class);

    @JsonCreator
    public static ValidTillGenerationType getByValue(String value) {
        return BY_VALUE.getByValue(value);
    }

    public static EPromoCodeValidTillGenerationType mapToProto(@Nullable ValidTillGenerationType restriction) {
        if (restriction == null) {
            return EPromoCodeValidTillGenerationType.PCVTGT_NONE;
        }
        return restriction.getProtoValue();
    }

}
