package ru.yandex.travel.orders.entities.promo.aeroflotplus;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Inspired by Taxi2020PromoCode
 */
@Entity
@Table(name = "aeroflot_plus_promo_codes")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AeroflotPlusPromoCode {
    @Id
    private String code;

    private Integer plusPoints;

    private Instant addedAt;

    private Instant expiresAt;

    private Instant usedAt;

    private UUID orderId;

    @Version
    private Integer version;
}
