package ru.yandex.travel.orders.entities.promo.mir2020;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "mir_2020_promo_orders")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Mir2020PromoOrder {
    @Id
    private UUID orderId;

    private String mirHotelId;

    private Integer cashbackAmount;

    @Type(type = "custom-enum")
    private MirPromoOrderEligibility eligibility;

    private Boolean paidWithMir;

    @CreationTimestamp
    private Instant createdAt;
}
