package ru.yandex.travel.orders.entities.promo.mir2020;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MirPromoOrderEligibility {
    ELIGIBLE("eligible"),
    BLACKLISTED("blacklisted"),
    WRONG_LOS("wrong_los"),
    WRONG_STAY_DATES("wrong_stay_dates"),
    PROMO_DISABLED("promo_disabled");


    private final String value;

    MirPromoOrderEligibility(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MirPromoOrderEligibility fromString(String value) {
        for (var candidate : MirPromoOrderEligibility.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown MirPromoOrderEligibility %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
