package ru.yandex.travel.orders.entities.promo.taxi2020;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "promo_2020_08_taxi_orders")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Taxi2020PromoOrder {
    @Id
    private UUID orderId;

    @Type(type = "custom-enum")
    private Taxi2020PromoOrderStatus status;

    private Instant statusUpdatedAt;

    private String email;

    private Instant emailScheduledAt;

    private String promoCode;

    private Instant sentAt;

    private UUID sendEmailOperationId;

    private UUID sendSmsOperationId;

    @Version
    private Integer version;
}
