package ru.yandex.travel.orders.entities.promo.taxi2020;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum Taxi2020PromoOrderStatus {
    // The order doesn't satisfy promo terms.
    NOT_ELIGIBLE("not_eligible"),
    // The order satisfies promo terms but it's still too early to send the email.
    ELIGIBLE("eligible"),
    // The order was ELIGIBLE and time to sent the email has come. Need to assign a free code first.
    PROMO_CODE_CAN_BE_ASSIGNED("promo_code_can_be_assigned"),
    // We need to send the promo email right now. The code has already been assigned.
    EMAIL_SCHEDULED("email_scheduled"),
    // The promo code has been sent to the user.
    EMAIL_SENT("email_sent");

    private final String value;

    // used by the @Type(type = "custom-enum") converter
    @SuppressWarnings("unused")
    public static Taxi2020PromoOrderStatus forValue(String value) {
        for (Taxi2020PromoOrderStatus type : values()) {
            if (type.getValue().equals(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("No Taxi2020PromoOrderStatus with such value: " + value);
    }
}
