package ru.yandex.travel.orders.entities.support;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import lombok.Data;

import ru.yandex.travel.orders.entities.HotelOrder;

@Entity
@Table(name = "support_successful_hotel_order_notifications")
@Data
public class SuccessfulHotelOrderNotification {
    @Id
    private UUID orderId;

    @OneToOne
    @MapsId
    private HotelOrder order;

    private Long permalink;

    private Instant sentAt;

    public UUID getOrderId() {
        return this.orderId;
    }

    public void setOrderId(UUID orderId) {
        this.orderId = orderId;
    }

    public HotelOrder getOrder() {
        return this.order;
    }

    public void setOrder(HotelOrder order) {
        this.order = order;
    }

    public Instant getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Instant sentAt) {
        this.sentAt = sentAt;
    }

    public Long getPermalink() {
        return this.permalink;
    }

    public void setPermalink(Long permalink) {
        this.permalink = permalink;
    }
}
