package ru.yandex.travel.orders.entities.support;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import lombok.Data;

import ru.yandex.travel.orders.entities.HotelOrder;

@Entity
@Table(name = "support_unsuccessful_hotel_order_notifications")
@Data
public class UnsuccessfulHotelOrderNotification {
    @Id
    private UUID orderId;

    @OneToOne
    @MapsId
    private HotelOrder order;

    private String passportId;

    private String sessionKey;

    private Instant sentAt;

    public UUID getOrderId() {
        return this.orderId;
    }

    public HotelOrder getOrder() {
        return this.order;
    }

    public String getPassportId() {
        return this.passportId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public Instant getSentAt() {
        return this.sentAt;
    }

    public void setOrderId(UUID orderId) {
        this.orderId = orderId;
    }

    public void setOrder(HotelOrder order) {
        this.order = order;
    }

    public void setPassportId(String passportId) {
        this.passportId = passportId;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setSentAt(Instant sentAt) {
        this.sentAt = sentAt;
    }
}
