package ru.yandex.travel.orders.grpc;

import javax.persistence.EntityNotFoundException;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import org.slf4j.Logger;
import org.springframework.dao.ConcurrencyFailureException;

import ru.yandex.travel.commons.grpc.ServerUtils;
import ru.yandex.travel.commons.proto.EErrorCode;
import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.commons.proto.TError;

import static ru.yandex.travel.commons.grpc.ServerUtils.statusFromError;

public class GrpcExceptionHelper {

    private GrpcExceptionHelper() {
    }

    public static <ReqT> StatusException mapStatusException(Logger log, ReqT request, Throwable ex) {
        log.warn("Caught exception {} while handling request {}",
                ex.getClass().getSimpleName(), request.getClass().getSimpleName(), ex);
        TError error = ProtoUtils.errorFromThrowable(ex, false);
        if (ex instanceof ConcurrencyFailureException) {
            error = error.toBuilder().setCode(EErrorCode.EC_ABORTED).build();
        }
        if (ex instanceof IllegalArgumentException) {
            error = error.toBuilder().setCode(EErrorCode.EC_INVALID_ARGUMENT).build();
        }
        if (ex instanceof EntityNotFoundException) {
            error = error.toBuilder().setCode(EErrorCode.EC_NOT_FOUND).build();
        }
        // TODO(tivelkov): passing verbose=true causes stack trace to get into headers, thus causing
        //  'Header size exceeded max allowed size'
        Status status = statusFromError(error);
        Metadata trailers = new Metadata();
        trailers.put(ServerUtils.METADATA_ERROR_KEY, error);
        return status.asException(trailers);
    }


}
