package ru.yandex.travel.orders.grpc;


import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.StreamObserver;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.Status;

import ru.yandex.travel.grpc.GrpcService;

@GrpcService
@Slf4j
@AllArgsConstructor
public class HealthCheckService extends HealthGrpc.HealthImplBase {
    private final HealthEndpoint healthEndpoint;

    @Override
    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        Status status = healthEndpoint.health().getStatus();
        HealthCheckResponse.Builder response = HealthCheckResponse.newBuilder()
                .setStatus(HealthCheckResponse.ServingStatus.NOT_SERVING);
        if (status.equals(Status.UP)) {
            response.setStatus(HealthCheckResponse.ServingStatus.SERVING);
        }
        responseObserver.onNext(response.build());
        responseObserver.onCompleted();
    }
}
