package ru.yandex.travel.orders.grpc;

import io.grpc.stub.StreamObserver;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.grpc.GrpcService;
import ru.yandex.travel.hotels.extranet.OrdersHotelsExtranetDataServiceGrpc;
import ru.yandex.travel.hotels.extranet.TGetDBoyReq;
import ru.yandex.travel.hotels.extranet.TGetDBoyRsp;
import ru.yandex.travel.orders.configurations.jdbc.TxScopeType;
import ru.yandex.travel.orders.grpc.helpers.TxCallWrapper;
import ru.yandex.travel.orders.infrastructure.CallDescriptor;
import ru.yandex.travel.orders.services.hotels_extranet.DBoyFinancialDataProvider;
import ru.yandex.travel.orders.services.hotels_extranet.DBoyOrderDataProvider;

@GrpcService(trace = false)
@Slf4j
@RequiredArgsConstructor
public class HotelExtranetService extends OrdersHotelsExtranetDataServiceGrpc.OrdersHotelsExtranetDataServiceImplBase {
    private final TxCallWrapper txCallWrapper;
    private final DBoyOrderDataProvider orderDataProvider;
    private final DBoyFinancialDataProvider financialDataProvider;

    @Override
    public void getDBoyOrderInfo(TGetDBoyReq request,
                                 StreamObserver<TGetDBoyRsp> responseObserver) {
        txCallWrapper.synchronouslyWithTx(
                CallDescriptor.readOnly(request), responseObserver, log, orderDataProvider::getOrderData,
                TxScopeType.READ_ONLY
        );
    }

    @Override
    public void getDBoyBankOrderInfo(TGetDBoyReq request,
                                     StreamObserver<TGetDBoyRsp> responseObserver) {
        txCallWrapper.synchronouslyWithTx(
                CallDescriptor.readOnly(request), responseObserver, log, financialDataProvider::getBankOrdersData,
                TxScopeType.READ_ONLY
        );
    }
}
