package ru.yandex.travel.orders.grpc;


import io.grpc.stub.StreamObserver;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.clients.promo_service_booking_flow.PromoServiceBookingFlowUtils;
import ru.yandex.travel.commons.grpc.ServerUtils;
import ru.yandex.travel.credentials.UserCredentials;
import ru.yandex.travel.grpc.GrpcService;
import ru.yandex.travel.orders.services.promo.UserOrderCounterService;
import ru.yandex.travel.orders.user_info.proto.TGetUserExistingOrderTypesReq;
import ru.yandex.travel.orders.user_info.proto.TGetUserExistingOrderTypesRsp;
import ru.yandex.travel.orders.user_info.proto.UserInfoInterfaceV1Grpc;

@Slf4j
@RequiredArgsConstructor
@GrpcService(authenticateUser = true, authenticateService = true)
public class UserInfoGrpcService extends UserInfoInterfaceV1Grpc.UserInfoInterfaceV1ImplBase {

    private final UserOrderCounterService userOrderCounterService;

    @Override
    public void getUserExistingOrderTypes(TGetUserExistingOrderTypesReq request,
                                          StreamObserver<TGetUserExistingOrderTypesRsp> responseObserver) {
        ServerUtils.synchronously(log, request, responseObserver,
                this::innerGetUserExistingOrderTypes,
                ex -> GrpcExceptionHelper.mapStatusException(log, request, ex)
        );
    }

    private TGetUserExistingOrderTypesRsp innerGetUserExistingOrderTypes(TGetUserExistingOrderTypesReq req) {
        String passportId = UserCredentials.get().getPassportId();
        return TGetUserExistingOrderTypesRsp.newBuilder()
                .addAllExistingOrderTypes(PromoServiceBookingFlowUtils.mapDisplayOrderTypesToOrderTypes(
                        userOrderCounterService.getUserExistingOrderTypes(passportId)))
                .build();
    }
}
