package ru.yandex.travel.orders.grpc.helpers;

import ru.yandex.travel.orders.commons.proto.EVat;
import ru.yandex.travel.orders.entities.VatType;

public class OrderProtoUtils {

    private OrderProtoUtils() {
    }

    public static VatType fromEVat(EVat eVat) {
        for (VatType candidate : VatType.values()) {
            if (candidate.getProtoValue() == eVat) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown proto EVat value %d", eVat.getNumber()));
    }

    public static EVat toEVat(VatType vatType) {
        return vatType.getProtoValue();
    }
}
