package ru.yandex.travel.orders.grpc.helpers;

import java.util.UUID;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.commons.grpc.CommonProtoChecks;
import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.commons.proto.EErrorCode;
import ru.yandex.travel.commons.proto.Error;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.commons.proto.EServiceType;

public class ProtoChecks {
    private ProtoChecks() {
    }

    public static String checkStringIsPresent(String field, String value) {
        Error.checkArgument(value != null, "Missing %s", field);
        Error.checkArgument(StringUtils.isNotEmpty(value), "Empty %s", field);
        return value;
    }

    public static UUID checkStringIsUuid(String field, String value) {
        return CommonProtoChecks.checkStringIsUuid(field, value);
    }

    public static ECurrency checkCurrency(String field, ECurrency value) {
        switch (value) {
            case C_UNKNOWN:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Missing %s", field).andThrow();
            case UNRECOGNIZED:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Unrecognized %s", field).withAttribute("value",
                        value.getNumber()).andThrow();
            default:
                return value;
        }
    }

    public static EServiceType checkProviderType(String field, EServiceType value) {
        switch (value) {
            case PT_UNKNOWN:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Missing %s", field).andThrow();
            case UNRECOGNIZED:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Unrecognized %s", field).withAttribute("value",
                        value.getNumber()).andThrow();
            default:
                return value;
        }
    }

    public static EOrderType checkOrderType(String field, EOrderType value) {
        switch (value) {
            case OT_UNKNOWN:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Missing %s", field).andThrow();
            case UNRECOGNIZED:
                Error.with(EErrorCode.EC_INVALID_ARGUMENT, "Unrecognized %s", field).withAttribute("value",
                        value.getNumber()).andThrow();
            default:
                return value;
        }
    }
}
