package ru.yandex.travel.orders.health;

import java.util.concurrent.atomic.AtomicBoolean;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import ru.yandex.travel.grpc.GrpcServerInitializedEvent;
import ru.yandex.travel.grpc.GrpcServerStoppedEvent;
import ru.yandex.travel.orders.proto.OrderInterfaceV1Grpc;

@Component
public class GrpcOrderServiceHealthIndicator implements HealthIndicator {

    private AtomicBoolean enabled = new AtomicBoolean(false);

    @EventListener
    public void onServerInitialized(GrpcServerInitializedEvent event) {
        if (event.getServer().getImmutableServices().stream().anyMatch(
                (ssd) -> ssd.getServiceDescriptor().equals(OrderInterfaceV1Grpc.getServiceDescriptor())
        )) {
            enabled.set(true);
        }
    }

    @EventListener
    public void onServerStopped(GrpcServerStoppedEvent event) {
        if (event.getServer().getImmutableServices().stream().anyMatch(
                (ssd) -> ssd.getServiceDescriptor().equals(OrderInterfaceV1Grpc.getServiceDescriptor())
        )) {
            enabled.set(false);
        }
    }

    @Override
    public Health health() {
        if (enabled.get()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
