package ru.yandex.travel.orders.infrastructure;

import com.google.common.base.Preconditions;
import org.flywaydb.core.Flyway;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;

public class CappedFlywayMigrationStrategy implements FlywayMigrationStrategy {
    private String maxMigrationVersion;

    public CappedFlywayMigrationStrategy(String maxMigrationVersion) {
        Preconditions.checkArgument(
                maxMigrationVersion != null,
                "Max migration version must be not null"
        );
        this.maxMigrationVersion = maxMigrationVersion;
    }

    @Override
    public void migrate(Flyway flyway) {
        Flyway.configure().target(maxMigrationVersion);
        flyway.migrate();
    }
}
