package ru.yandex.travel.orders.infrastructure.jpa.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.google.common.base.Preconditions;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

public class MoneyProtoEnumType implements CompositeUserType {
    @Override
    public String[] getPropertyNames() {
        return new String[]{"value", "currency"};
    }

    @Override
    public Type[] getPropertyTypes() {
        return new Type[]{
                BigDecimalType.INSTANCE, ProtoCurrencyUnitType.INSTANCE
        };
    }

    @Override
    public Object getPropertyValue(Object component, int property) throws HibernateException {
        if (component == null) {
            return null;
        }
        final Money money = (Money) component;
        switch (property) {
            case 0: {
                return money.getNumber().numberValue(BigDecimal.class);
            }
            case 1: {
                return money.getCurrency();
            }
            default: {
                throw new HibernateException("Invalid property index [" + property + "]");
            }
        }
    }

    @Override
    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new HibernateException("Money is immutable, so properties cannot be changed");
    }

    @Override
    public Class returnedClass() {
        return Money.class;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x != null && y != null) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Preconditions.checkArgument(names.length == 2);

        BigDecimal amount = (BigDecimal) BigDecimalType.INSTANCE.get(rs, names[0], session);
        ProtoCurrencyUnit currency = (ProtoCurrencyUnit) ProtoCurrencyUnitType.INSTANCE.nullSafeGet(rs, new String[]{names[1]}, session, owner);


        return amount == null || currency == null
                ? null
                : Money.of(amount, currency);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            BigDecimalType.INSTANCE.set(st, null, index, session);
            ProtoCurrencyUnitType.INSTANCE.nullSafeSet(st, null, index + 1, session);
        } else {
            final Money money = (Money) value;
            BigDecimalType.INSTANCE.set(st, money.getNumber().numberValue(BigDecimal.class), index, session);
            ProtoCurrencyUnitType.INSTANCE.nullSafeSet(st, money.getCurrency(), index + 1, session);
        }
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session) throws HibernateException {
        return (Serializable) value;
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return original;
    }

}
