package ru.yandex.travel.orders.infrastructure.jpa.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

public class ProtoCurrencyUnitType extends AbstractSingleColumnStandardBasicType<ProtoCurrencyUnit> {

    public static final ProtoCurrencyUnitType INSTANCE = new ProtoCurrencyUnitType();

    public ProtoCurrencyUnitType() {
        super(SqlTypeDesc.INSTANCE, JavaTypeDesc.INSTANCE);
    }


    @Override
    public String getName() {
        return "proto-currency-unit";
    }

    private static final class SqlTypeDesc implements SqlTypeDescriptor {

        static final SqlTypeDesc INSTANCE = new SqlTypeDesc();

        @Override
        public int getSqlType() {
            return Types.VARCHAR;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this) {
                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setString(index, javaTypeDescriptor.unwrap(value, String.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setString(name, javaTypeDescriptor.unwrap(value, String.class, options));
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this) {
                @Override
                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getString(name), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getString(name), options);
                }
            };
        }
    }

    private static final class JavaTypeDesc extends AbstractTypeDescriptor<ProtoCurrencyUnit> {

        static final JavaTypeDesc INSTANCE = new JavaTypeDesc();

        JavaTypeDesc() {
            super(ProtoCurrencyUnit.class);
        }

        @Override
        public String toString(ProtoCurrencyUnit value) {
            return value.getCurrencyCode();
        }

        @Override
        public ProtoCurrencyUnit fromString(String string) {
            return ProtoCurrencyUnit.fromCurrencyCode(string);
        }

        @Override
        @SuppressWarnings("unchecked")
        public <X> X unwrap(ProtoCurrencyUnit value, Class<X> type, WrapperOptions options) {
            if (value == null) {
                return null;
            }
            if (String.class.isAssignableFrom(type)) {
                return (X) toString(value);
            }
            throw unknownUnwrap(type);
        }

        @Override
        public <X> ProtoCurrencyUnit wrap(X value, WrapperOptions options) {
            if (value == null) {
                return null;
            }
            return fromString(value.toString());
        }
    }
}
