package ru.yandex.travel.orders.management;

import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "st", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class StarTrekConfigurationProperties {
    @NotEmpty
    private String url;
    @NotEmpty
    private String oauthToken;
    private Duration connectionTimeout = Duration.ofSeconds(1);
    private Duration socketTimeout = Duration.ofSeconds(15);
    private String travelAdminUrl;

    @NotNull
    private Duty duty;

    private String autoQueueName;
    private String manualQueueName;
    private String hotelAccountQueueName;
    private String aeroflotCancelledOrderPaidIssueTitle = "Оплачен отменённый заказ %s";
    private String aeroflotFailedTokenizationIssueTitle = "Проблемы с токенизацией карты для заказа %s";
    private String aeroflotLostOrderIssueTitle = "Оплачен отсутствующий заказ %s";
    private String errorGettingDescription = "Не удалось получить описание для ошибочного процесса, связанного с заказом %s";
    private String errorIssueTitle = "Сломался заказ %s";
    private String errorIssueType = "task";
    private String hotelOrderPriceMismatchIssueTitle = "Несовпадение итоговой цены для отельного заказа %s";
    private String mailNotSentErrorGettingDescription = "Не удалось получить описание для ошибочного процесса с ошибкой посылки email %s";
    private String mailNotSentErrorGettingTitle = "Не удалось послать email %s";
    private String mailNotSentIssueTitle = "Не удалось послать email о заказе %s";
    private String mailNotSentIssueType = "task";
    private String manualProcessingIssueTitle = "Заказ %s переведен в ручную обработку";
    private String notificationNotSentErrorGettingDescription = "Не удалось получить описание для ошибочного процесса с ошибкой посылки уведомления %s";
    private String notificationNotSentErrorGettingTitle = "Не удалось послать уведомление %s";
    private String notificationNotSentIssueTitle = "Не удалось послать уведомление о заказе %s";
    private String plusPointsTopupFailedTitle = "Не удалось пополнить баланс Яндекс.Плюс для заказа %s";
    private String orderPaidNotConfirmedErrorGettingDescription = "Не удалось получить описание для ошибочного процесса с заказом %s с ошибкой выписки после оплаты";
    private String orderPaidNotConfirmedIssueTitle = "Заказ %s оплачен, но бронь не подтверждена";
    private String orderPaidNotConfirmedIssueType = "task";
    private String pdfNotReceivedErrorGettingDescription = "Не удалось получить описание для ошибочного процесса с ошибкой получения ваучера %s подтверждения заказа";
    private String pdfNotReceivedErrorGettingTitle = "Не удалось получить ссылку на PDF %s";
    private String pdfNotReceivedIssueTitle = "Не удалось получить ссылку на PDF для заказа %s";
    private String pdfNotReceivedIssueType = "task";
    private String trainInsuranceInvalidAmountTitle = "В заказе %s не сходится сумма страховки";
    private String trainRebookingValidationErrorTitle = "В заказе %s провалена валидация перебронирования";
    private String emptyTrainCarrierInnTitle = "В заказе %s отсутствует ИНН перевозчика";
    private String trainInsuranceNotAddedTitle = "Для заказа %s не удалось добавить страховку";
    private String trainInsuranceNotConfirmedTitle = "Для заказа %s не удалось подтвердить страховку";
    private String trainInsuranceRefundFailedTitle = "Для заказа %s провален автовозврат страховки";
    private String trainTicketRefundFailedTitle = "Для заказа %s провален возврат";
    private String trainOfficeRefundHandleError = "Ошибка обработки кассового возврата для заказа %s";
    private String trustReceiptNotFetchedTitle = "Письмо по заказу %s отправлено без чека";
    private String trustRefundErrorTitle = "Ошибка при возврате денег по заказу %s";
    private String workflowErrorIssueTitle = "Сломалось workflow %s %s";
    private String deferredPaymentReminderIssueTitle = "Подходит к концу рассрочка по заказу %s";
    private String returnedPaymentOrderIssueTitle = "Вернулся платеж по платежному поручению %s по контракту %s";
    private String paymentDashboardLink = "https://datalens.yandex-team.ru/zv7fpa6w5014w-partner-payouts?tab=25r&bank_order_id=%s";
    private String boyDutyHowToUrl = "https://wiki.yandex-team.ru/travel/hotels/dev/systems/Pamjatka-dezhurnogo-Travel-BoY/";
    private String trustSupportFormUrl = "https://wiki.yandex-team.ru/trust/sup/?from=%2Ftikety-po-blacklisted%2F#forma";

    @Data
    @Valid
    public static class Duty {
        @NotEmpty
        private String avia;
        @NotEmpty
        private String buses;
        @NotEmpty
        private String hotels;
        @NotEmpty
        private String orchestrator;
        @NotEmpty
        private String suburban;
        @NotEmpty
        private String trains;
    }
}
