package ru.yandex.travel.orders.management;

import java.util.List;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.WellKnownWorkflow;
import ru.yandex.travel.orders.entities.WellKnownWorkflowEntityType;
import ru.yandex.travel.tx.utils.TransactionMandatory;
import ru.yandex.travel.workflow.EWorkflowState;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Service
@RequiredArgsConstructor
public class SupervisorService {
    private final WorkflowRepository workflowRepository;

    @TransactionMandatory
    public void ensureSupervisorsExist() {
        ensureOrderSupervisorExists();
        ensureGeneralErrorSupervisorExists();
    }

    private void ensureOrderSupervisorExists() {
        List<Workflow> workflowList = workflowRepository.findAllByEntityType(WellKnownWorkflowEntityType.ORDER_SUPERVISOR.getDiscriminatorValue());
        Preconditions.checkState(workflowList.size() <= 1, "There should be only 1 workflow with type: " + WellKnownWorkflowEntityType.ORDER_SUPERVISOR);
        if (workflowList.size() == 0) {
            Workflow workflow = new Workflow();
            workflow.setId(WellKnownWorkflow.ORDER_SUPERVISOR.getUuid());
            workflow.setEntityType(WellKnownWorkflowEntityType.ORDER_SUPERVISOR.getDiscriminatorValue());
            workflow.setState(EWorkflowState.WS_RUNNING);
            workflowRepository.saveAndFlush(workflow);
        }
    }

    private void ensureGeneralErrorSupervisorExists() {
        List<Workflow> workflowList = workflowRepository.findAllByEntityType(WellKnownWorkflowEntityType.GENERIC_ERROR_SUPERVISOR.getDiscriminatorValue());
        Preconditions.checkState(workflowList.size() <= 1, "There should be only 1 workflow with type: " + WellKnownWorkflowEntityType.GENERIC_ERROR_SUPERVISOR);
        if (workflowList.size() == 0) {
            Workflow workflow = new Workflow();
            workflow.setId(WellKnownWorkflow.GENERIC_ERROR_SUPERVISOR.getUuid());
            workflow.setEntityType(WellKnownWorkflowEntityType.GENERIC_ERROR_SUPERVISOR.getDiscriminatorValue());
            workflow.setState(EWorkflowState.WS_RUNNING);
            workflowRepository.saveAndFlush(workflow);
        }
    }
}
