package ru.yandex.travel.orders.management.metrics;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.repository.OrderRepository;
import ru.yandex.travel.workflow.EWorkflowEventState;
import ru.yandex.travel.workflow.WorkflowProcessService;
import ru.yandex.travel.workflow.repository.WorkflowEventRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@ConditionalOnProperty("metrics.enabled")
public class GaugeServiceConfiguration {

    @Bean
    @ConfigurationProperties(value = "metrics", ignoreUnknownFields = false)
    public GaugeServiceProperties gaugeServiceProperties() {
        return new GaugeServiceProperties();
    }

    @Bean
    public GaugeService gaugeService(OrderRepository orderRepository,
                                     WorkflowRepository workflowRepository,
                                     StarTrekService starTrekService,
                                     TransactionTemplate transactionTemplate,
                                     WorkflowProcessService workflowProcessService,
                                     GaugeServiceProperties gaugeServiceProperties
    ) {
        return new GaugeService(
                orderRepository, workflowRepository, starTrekService, transactionTemplate,
                workflowProcessService, gaugeServiceProperties
        );
    }

    @Bean
    public GaugeServiceDbMetric newWorkflowEventDbMetric(WorkflowEventRepository workflowEventRepository) {
        return new GaugeServiceSimpleDbMetric("workflow.processing","newEvents") {
            @Override
            public double getValue() {
                return workflowEventRepository.countByStateEquals(EWorkflowEventState.WES_NEW);
            }
        };
    }

}
