package ru.yandex.travel.orders.management.metrics;

import java.time.Duration;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.validation.annotation.Validated;

@Getter
@Setter
@Validated
public class GaugeServiceProperties {

    private boolean enabled;
    private boolean schedulerEnabled;

    @NotEmpty
    private String gaugePrefix;
    @NotNull
    private GaugeServiceProperties.DB db;
    @NotNull
    private GaugeServiceProperties.ST st;
    @NotNull
    private Duration shutdownTimeout;

    @Getter
    @Setter
    @Validated
    public static class DB {
        @NotNull
        private Duration updateInterval;
    }

    @Getter
    @Setter
    @Validated
    public static class ST {
        @NotNull
        private Boolean enabled;
        @NotNull
        private Duration updateInterval;
        @NotEmpty
        private List<String> queueNames;
        @NotNull
        private Integer maxIssues;
    }
}
