package ru.yandex.travel.orders.repository;

import java.math.BigDecimal;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import ru.yandex.travel.orders.entities.Account;

public interface AccountRepository extends JpaRepository<Account, UUID> {

    @Query(value = "select sum(delta) from account_records where account_id = :accountId", nativeQuery = true)
    BigDecimal getCurrentBalanceForAccount(@Param("accountId") UUID uuid);
}
