package ru.yandex.travel.orders.repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;

public interface AeroflotOrderRepository extends JpaRepository<AeroflotOrder, UUID> {

    @Query("SELECT o FROM AeroflotOrder o " +
            "WHERE o.state = " + EAeroflotOrderState.OS_CONFIRMED_VALUE + " " +
            "AND (o.removed IS NULL OR o.removed = FALSE) " +
            "AND o.servicedAt > ?1")
    List<Order> findAllActiveOrders(LocalDateTime servicedAt);
}
