package ru.yandex.travel.orders.repository;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.AuthorizedUser;

public interface AuthorizedUserRepository extends JpaRepository<AuthorizedUser, AuthorizedUser.Key> {

    List<AuthorizedUser> findByIdOrderId(UUID orderId);

    List<AuthorizedUser> findByIdOrderIdAndRole(UUID orderId, AuthorizedUser.OrderUserRole role);

    List<AuthorizedUser> findByIdOrderIdInAndRole(Set<UUID> orderId, AuthorizedUser.OrderUserRole role);

    void deleteAllByIdOrderIdAndRole(UUID orderId, AuthorizedUser.OrderUserRole role);
}
