package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.EBNovoItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface BNovoOrderItemRepository extends JpaRepository<BNovoOrderItem, UUID> {
    List<BNovoOrderItem> getAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotInOrderByExpiresAtAsc(
            Collection<EBNovoItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds,
            Pageable pageable
    );

    Long countAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotIn(
            Collection<EBNovoItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds
    );
}
