package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.Set;

import javax.persistence.Tuple;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ru.yandex.travel.orders.entities.finances.ProcessingTasksInfo;
import ru.yandex.travel.orders.entities.partners.BillingPartnerConfig;

import static ru.yandex.travel.orders.repository.BillingTransactionRepository.convertProcessingTasksInfo;

public interface BillingPartnerConfigRepository extends JpaRepository<BillingPartnerConfig, Long> {
    Set<Long> NO_EXCLUDE_IDS = Set.of(-1L);

    @Query("SELECT c.billingClientId FROM BillingPartnerConfig c WHERE c.synchronizeAgreement = true" +
            " AND (c.synchronizedAt < ?1 OR c.synchronizedAt IS null) AND c.billingClientId NOT IN ?2 " +
            "ORDER BY c.synchronizedAt ASC NULLS FIRST")
    List<Long> findIdsForAgreementSynchronization(
            Instant lastSynchronizedAt, Set<Long> excludeIds, Pageable pageable);

    @Query("SELECT c.billingClientId FROM BillingPartnerConfig c")
    List<Long> findAllClientIds();

    @Query("SELECT count(c) FROM BillingPartnerConfig c WHERE c.synchronizeAgreement = true" +
            " AND (c.synchronizedAt < ?1 OR c.synchronizedAt IS null) AND c.billingClientId NOT IN ?2")
    long countIdsForAgreementSynchronization(
            Instant lastSynchronizedAt, Set<Long> excludeIds);

    @Query("SELECT MIN(CASE WHEN c.synchronizedAt IS NOT NULL THEN c.synchronizedAt ELSE c.createdAt END), count(*) " +
            "FROM BillingPartnerConfig c WHERE c.synchronizeAgreement = true" +
            " AND (c.synchronizedAt < ?1 OR c.synchronizedAt IS null)")
    Tuple findOldestTimestampForAgreementSynchronizationRaw(Instant lastSynchronizedAt);
    default ProcessingTasksInfo findOldestTimestampForAgreementSynchronization(Instant lastSynchronizedAt) {
        return convertProcessingTasksInfo(findOldestTimestampForAgreementSynchronizationRaw(lastSynchronizedAt));
    }
}
