package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import ru.yandex.travel.orders.entities.BronevikOrderItem;
import ru.yandex.travel.orders.workflow.hotels.bronevik.proto.EBronevikItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface BronevikOrderItemRepository extends JpaRepository<BronevikOrderItem, UUID> {
    List<BronevikOrderItem> getAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotInOrderByExpiresAtAsc(
            Collection<EBronevikItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds,
            Pageable pageable
    );

    Long countAllByIsExpiredIsFalseAndStateInAndExpiresAtIsBeforeAndWorkflowStateIsAndIdIsNotIn(
            Collection<EBronevikItemState> itemStates,
            Instant expiresAt,
            EWorkflowState workflowState,
            Collection<UUID> excludeIds
    );
}
