package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.EAeroflotInvoiceState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomAeroflotInvoiceRepository {
    List<UUID> getInvoiceIdsAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                                 EAeroflotInvoiceState invoiceState,
                                                                 EWorkflowState workflowState,
                                                                 Collection<UUID> exclusions,
                                                                 Pageable pageable);

    long countInvoicesAwaitingRefreshInStateWithExclusions(Instant nextCheckStatusAt,
                                                          EAeroflotInvoiceState invoiceState,
                                                          EWorkflowState workflowState,
                                                          Collection<UUID> exclusions);
}
