package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomBusOrderItemRepository {
    List<UUID> getExpiredOrderItems(Instant expiredAt,
                                    Collection<EOrderItemState> itemStates, EWorkflowState workflowState,
                                    Collection<UUID> excludeIds,
                                    Pageable pageable);

    long countExpiredOrderItems(Instant expiredAt,
                                Collection<EOrderItemState> states, EWorkflowState workflowState,
                                Collection<UUID> excludeIds);
}
