package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.notification.proto.ENotificationState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomNotificationRepository {
    List<UUID> getNotificationsPreparingTill(Instant now, ENotificationState state, EWorkflowState wfState,
                                             boolean expired, Collection<UUID> excludeIds, Pageable pageable);

    long countNotificationsPreparingTill(Instant now, ENotificationState state, EWorkflowState wfState,
                                         boolean expired, Collection<UUID> excludeIds);
}
