package ru.yandex.travel.orders.repository;

import java.util.Collection;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class CustomOrderChangeRepositoryImpl implements CustomOrderChangeRepository{
    private final EntityManager entityManager;

    @Override
    public List<UUID> getOrdersWaitingForIndexing(Collection<UUID> excluded, Pageable pageable) {
        var query = entityManager.createQuery(commonJpaQl("DISTINCT o.orderId", excluded))
                .setFirstResult(pageable.getPageNumber() * pageable.getPageSize())
                .setMaxResults(pageable.getPageSize());
        if (!excluded.isEmpty()) {
            query.setParameter("excluded", excluded);
        }
        return query.getResultList();
    }

    @Override
    public Long countOrdersWaitingForIndexing(Collection<UUID> excluded) {
        var query = entityManager.createQuery(commonJpaQl("count(DISTINCT o.orderId)", excluded));
        if (!excluded.isEmpty()) {
            query.setParameter("excluded", excluded);
        }
        return (Long) query.getResultList().get(0);
    }

    private String commonJpaQl(String selectPart, Collection<UUID> exclusions) {
        return "SELECT " + selectPart + " FROM ru.yandex.travel.orders.entities.OrderChange o" +
                (exclusions.isEmpty() ? "" : "  WHERE o.orderId NOT IN (:excluded)");
    }
}
