package ru.yandex.travel.orders.repository;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.entities.AdminListOrdersParams;
import ru.yandex.travel.orders.entities.Order;

public interface CustomOrderRepository {
    List<Order> findOrdersOwnedByUser(String passportId,
                                      Set<EDisplayOrderType> displayTypes,
                                      Set<EDisplayOrderState> displayStates,
                                      Pageable pageable);

    List<Order> findAllOrdersOwnedByUser(String passportId);

    List<Order> findOrdersWithAdminFilters(AdminListOrdersParams params);

    List<Order> findOrdersOwnedByUserWithoutExcluded(
            String passportId,
            Set<UUID> excludedOrderIds,
            Set<EDisplayOrderType> displayTypes,
            Set<EDisplayOrderState> displayStates,
            Pageable pageable);

    List<Order> selectNotRemovedOrders(Set<UUID> orderIds);
}
