package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.entities.PaymentScheduleItem;

public interface CustomPaymentScheduleItemRepository {
    List<PaymentScheduleItem> findItemsForEmailReminderWithNoNotifications(Instant reminderInstant, Set<UUID> activeIds,
                                                                           Pageable pageable);

    Long countItemsForEmailReminderWithNoNotifications(Instant reminderInstant, Set<UUID> activeIds);

    List<PaymentScheduleItem> findItemsForTicketReminderWithNoNotifications(Instant reminderInstant, Set<UUID> activeIds,
                                                                           Pageable pageable);

    Long countItemsForTicketReminderWithNoNotifications(Instant reminderInstant, Set<UUID> activeIds);

    List<PaymentScheduleItem> findItemsForAutoPayment(Instant reminderInstant, Set<UUID> activeIds, Pageable pageable);

    Long countItemsForAutoPayment(Instant reminderInstant, Set<UUID> activeIds);
}
