package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;

public interface CustomPaymentScheduleRepository {
    List<PaymentSchedule> findNonExpiredSchedulesInGivenStatesExpiringBeforeInstant(Set<EPaymentState> scheduleStates,
                                                                                    Set<EPaymentState> states,
                                                                                    Instant expirationInstant,
                                                                                    Set<UUID> activeIds, Pageable page);

    Long countNonExpiredSchedulesInGivenStatesExpiringBeforeInstant(Set<EPaymentState> scheduleStates,
                                                                    Set<EPaymentState> itemStates,
                                                                    Instant expirationInstant,
                                                                    Set<UUID> activeIds);
}
