package ru.yandex.travel.orders.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomSimpleTrustRefundRepository {
    List<UUID> getTrustRefundWaitingForRefreshStatus(Collection<UUID> excluded,
                                                     LocalDateTime nextCheckStatusAt,
                                                     EWorkflowState workflowState,
                                                     Pageable pageable);

    long countTrustRefundWaitingForRefreshStatus(Collection<UUID> excluded,
                                                 LocalDateTime nextCheckStatusAt,
                                                 EWorkflowState workflowState);
}
