package ru.yandex.travel.orders.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import ru.yandex.travel.workflow.EWorkflowState;

@Component
@Slf4j
@RequiredArgsConstructor
public class CustomSimpleTrustRefundRepositoryImpl implements CustomSimpleTrustRefundRepository {
    private final EntityManager entityManager;

    @Override
    public List<UUID> getTrustRefundWaitingForRefreshStatus(Collection<UUID> excluded, LocalDateTime nextCheckStatusAt, EWorkflowState workflowState, Pageable pageable) {
        var query = entityManager.createQuery(commonJpaQl("i.id", excluded))
                .setParameter("nextCheckStatusAt", nextCheckStatusAt)
                .setParameter("workflowState", workflowState)
                .setFirstResult(Long.valueOf(pageable.getOffset()).intValue())
                .setMaxResults(pageable.getPageSize());
        if (!excluded.isEmpty()) {
            query.setParameter("excluded", excluded);
        }
        return query.getResultList();
    }

    @Override
    public long countTrustRefundWaitingForRefreshStatus(Collection<UUID> excluded, LocalDateTime nextCheckStatusAt,
                                                        EWorkflowState workflowState) {
        var query = entityManager.createQuery(commonJpaQl("count(i.id)", excluded))
                .setParameter("nextCheckStatusAt", nextCheckStatusAt)
                .setParameter("workflowState", workflowState);
        if (!excluded.isEmpty()) {
            query.setParameter("excluded", excluded);
        }
        return (Long) query.getResultList().get(0);
    }

    private String commonJpaQl(String selectPart, Collection<UUID> exclusions) {
        return "SELECT " + selectPart + " FROM ru.yandex.travel.orders.entities.SimpleTrustRefund i INNER JOIN i.workflow w" +
                "  WHERE i.nextCheckStatusAt IS NOT NULL AND i.nextCheckStatusAt <= :nextCheckStatusAt" +
                (exclusions.isEmpty() ? "" : " AND i.id NOT IN (:excluded) ") +
                "  AND w.state = :workflowState AND i.systemRefreshScheduled = false";
    }
}
