package ru.yandex.travel.orders.repository;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Pageable;

import ru.yandex.travel.orders.workflow.orderitem.train.insurancerefund.proto.ETrainInsuranceRefundState;
import ru.yandex.travel.workflow.EWorkflowState;

public interface CustomTrainInsuranceRefundRepository {
    List<UUID> getInsuranceRefundsForCheck(Instant now,
                                           ETrainInsuranceRefundState state,
                                           EWorkflowState workflowState,
                                           Collection<UUID> excludeIds,
                                           Pageable pageable);

    long countInsuranceRefundsForCheck(Instant now,
                                       ETrainInsuranceRefundState state,
                                       EWorkflowState workflowState,
                                       Collection<UUID> excludeIds);
}
