package ru.yandex.travel.orders.repository;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import javax.persistence.EntityManager;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class CustomTrainRefundedOperationRepositoryImpl implements CustomTrainRefundedOperationRepository {
    private final EntityManager em;

    @Override
    public Set<Integer> excludeRefundedOperationIds(@NotNull Set<Integer> operationIds) {
        if (operationIds.isEmpty()) {
            return Collections.emptySet();
        }

        var query = em.createQuery(
                "SELECT operationId FROM ru.yandex.travel.orders.entities.TrainRefundedOperation " +
                        "WHERE operationId IN (:operationIds)",
                Integer.class
        );
        query.setParameter("operationIds", operationIds);
        var refundedOperationIds = query.getResultStream().collect(Collectors.toSet());

        var filteredOperationIds = new HashSet<>(operationIds);
        filteredOperationIds.removeAll(refundedOperationIds);
        return filteredOperationIds;
    }
}
